import iesve

project = iesve.VEProject.get_current_project()
model = project.models[0]
bodies = model.get_bodies(False)

constructions =[]

for body in bodies:
    constr = body.get_assigned_constructions()
    for item in constr:
        constructions.append(item[0])

print(constructions)


db = iesve.VECdbDatabase.get_current_database()
projects = db.get_projects()
project_list = projects[0]
project = project_list[0]

c_class = iesve.construction_class.glazed                
ids = project.get_construction_ids(c_class)

for id in ids:
    if id in constructions:
        construction = project.get_construction(id, c_class)
        print(id)
        prop = construction.get_properties()
        print(prop)

c_class = iesve.construction_class.opaque                
ids = project.get_construction_ids(c_class)

for id in ids:
    if id in constructions:
        construction = project.get_construction(id, c_class)
        print(id)
        layers = construction.get_layers()
        for layer in layers:
            material = layer.get_material(True)
            if material is not None:
                properties = material.get_properties()
                print(properties['description'],"has a conductivity of",properties['conductivity'],"W/m/K")

